//AIM:Computation of maximum bit rate for RZ & NRZ encoding for the pulse 
//spreading constants & certain cable lengths

//Software version Scilab 5.5.2
//OS Windows 7
clc;
clear;
//Consider pulse spreading constants & cable lengths as follows:
//(i):ΔT=10ns/mm,L=100m;(ii):ΔT=20ns/m,L=1000m ;(iii):ΔT=2000ns/m,L=2km

//To find maximum bit rate for RZ & NRZ encoding 
//(i):Since delT1=10ns/mm and 1mm=10^-6 km
delT1=10*(10^(-9))*(10^(6));
disp('sec/km',delT1,'delT1=')
tao1=0.1*delT1;//Computing total dispersion for 100 m
disp('sec',tao1,'Total dispersion for 100 m=')
//Maximum possible optical bandwidth=maximum possible bit rate for RZ
Bopt1=1/(2*tao1)
disp('bits/sec',Bopt1,'Maximum possible bit rate for RZ=')
NRZ1=Bopt1/2;
disp('bits/sec',NRZ1,'Maximum possible bit rate for NRZ=')
//(ii):Since delT2=20ns/m and 1m=10^-3km
delT2=20*(10^(-9))/(10^(-3));
disp('sec',delT2,'Total dispersion for 1000 m or 1 km =')
tao2=delT2;
Bopt2=1/(2*tao2)
disp('bits/sec',Bopt2,'Maximum possible bit rate for RZ=')
NRZ2=Bopt2/2;
disp('bits/sec',NRZ2,'Maximum possible bit rate for NRZ=')
//(iii):Since delT3=2000ns/m and 1m=10^-3km
delT3=2000*(10^(-9))/(10^(-3));
disp('sec/km',delT3,'delT3=')
tao3=delT3*2;
disp('sec',tao3,'Total dispersion over a length of 2 km =')
Bopt3=1/(2*tao3)
disp('bits/sec',Bopt3,'Maximum possible bit rate for RZ=')
NRZ3=Bopt3/2;
disp('bits/sec',NRZ3,'Maximum possible bit rate for NRZ=')
